<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;
use Nwidart\Modules\Facades\Module;
use \Route;

class DevController extends Controller
{
    //reload databse
    public function dbReload(){
        //clear databse
        Artisan::call('db:wipe');

        //import datable
        
        DB::unprepared(file_get_contents(root_path().'public/dev/credhyip.sql'));        
              
        return 'Database Refreshed';
    }

    //list routes
    public function getRoutes(){
        return view('routes');
    }

    public function zipAddon(Request $request) 
    {
        $name  = $request->route('addon');
        //zip the files  
        $addon = Module::find($name);
        if (!$addon) {
            dd('Not Found');
        }   
        
        $zipPath = $addon->getPath();
        $create = makeArchive($zipPath);

        if ($create){
            return 'Created';
        } else {
            return 'Not Create';
        }
        
    }

    public function makeTranslation()
    {
        $trans = [
            "login" => "login",
            "email" => "email",
            "password" => "password",
            "forgot password" => "Forgot password",
            "register" => "register",
            "edit profile" => "edit profile",
            "back" => "back",
            "Account Information" => "Account Information",
            "First Name" => "First Name",
            "Last Name" => "Last Name",
            "Date Of Birth" => "Date Of Birth",
            "Phone No" => "Phone No",
            "Address" => "Address",
            "State" => "State/Region",
            "Country" => "Country",
            "Profile Picture" => "Profile Picture",
            "select image" => "select image",
            "Save changes" => "Save changes",
            "My Profile" => "My Profile",
            "Profile Overview" => "Profile Overview",
            "Edit" => "Edit",
            "Account ID" => "Account ID",
            "Available Bal" => "Available Bal",
            "Email address" => "Email address",
            "Account Standings" => "Account Standings",
            'Status' => "Status",
            "Email Verification" => "Email Verification",
            "KYC Verification" => "KYC Verification",
            "Location Information" => "Location Information",
            "Referral Details" => "Referral Details",
            "Referrred By" => "Referrred By",
            "Total Referrals" => "Total Referrals",
            "Date" => "Date",
            "Name" => "Name",
            "no referral" => "You don't have any referrals",
            "Resend Verification Link" => "Resend Verification Link",
            "Contact Support" => "Contact Support",
            "Reset Password" => "Reset Password",
            "Back to Login" => "Back to Login",
            "Login OTP" => "Login OTP",
            "OTP" => "OTP",
            "Verify" => "Verify",
            "Resend OTP" => "Resend OTP",
            "Current Address" => "Current Address",
            "Select gender" => "Select gender",
            "Male" => "Male",
            "Neutral" => "Neutral",
            "Female" => "Female",
            "D.O.B" => "D.O.B",
            "Referred By" => "Referred By",
            "Confirm Password" => "Confirm Password",
            "Sign up" => "Sign up",
            "Already Have Account? Login" => "Already Have Account? Login",
            "my deposit" => "my deposit",
            "Total deposits" => "Total deposits",
            "Pending deposits" => "Pending deposits",
            "Approved deposits" => "Approved deposits",
            "Rejected deposits" => "Rejected deposits",
            "Amount" => "Amount",
            "Method" => "Method",
            "Action" => "Action",
            "Empty Record!" => "Empty Record!",
            "You haven't made any deposit yet" => "You haven't made any deposit yet",
            "make new deposit" => "make new deposit",
            "swipe right to see all available payment methods" => "swipe right to see all available payment methods",
            "Min" => "Min",
            "Max" => "Max",
            "Charge" => "Charge",
            "Next" => "Next",
            "Deposit details" => "Deposit details",
            "Payment Method Amount" => "Payment Method Amount",
            "Payment Method" => "Payment Method",
            "Deposit Charge" => "Deposit Charge",
            "Additional Info" => "Additional Info",
            "Payment Screenshot" => "Payment Screenshot",
            "user status" => " user status",
            "Hi" => "Hi", 
            "To begin your id verification" => "To begin your id verification", 
            "Click here" => "Click here",
            "You are about to start your account verfication. If any of the gray out fields do not reflect your intended value," => "You are about to start your account verfication. If any of the gray out fields do not reflect your intended value,", 
            "to edit your account before proceeding." => "to edit your account before proceeding.",
            "START NOW" => "START NOW", 
            "Step 1" => "Step 1", 
            "Marital Status" => "Marital Status", 
            "Select status" => "Select status", 
            "Married" => "Married", 
            "Single" => "Single", 
            "Divorced" => "Divorced", 
            "This field needs your attention" => "This field needs your attention", 
            "Step 2" => "Step 2", 
            "Address Details" => "Address Details",
            "Step 3" => "Step 3", 
            "ID Document Upload" => "ID Document Upload", 
            "Id Document Type" => "Id Document Type", 
            "Select type" => "Select type", 
            "Passport" => "Passport", 
            "Driving License" => "Driving License", 
            "Voter Card" => "Voter Card",
            "National ID Card" => "National ID Card", 
            "Front ID" => "Front ID",
            "Choose file" => "Choose file", 
            "Back ID" => "Back ID", 
            "Selfie" => "Selfie",
            "Step 4" => "Step 4", 
            "TERMS" => "TERMS", 
            "By Proceeding to submit your provided KYC Documents, you agree to that all information provided are accurate and represent you." => "By Proceeding to submit your provided KYC Documents, you agree to that all information provided are accurate and represent you.",
            "Agree" => "Agree", 
            "My Investments" => "My Investments", 
            "Total earnings" => "Total earnings", 
            "Total invested" => "Total invested", 
            "Amount Invested" => "Amount Invested", 
            "Amount Earned" => "Amount Earned", 
            "Last Profit" => "Last Profit",
            "NILL" => "NILL", 
            "Next Profit" => "Next Profit", 
            "You haven't made any investments" => "You haven't made any investments", 
            "New Investment Plan" => "New Investment Plan", 
            "You have selected the" => "You have selected the",
            "Minimum and maximum investment amount are" => "Minimum and maximum investment amount are",
            "respectively" => "respectively", 
            "enter amount" => "enter amount", 
            "You have selected the" => "You have selected the",
            "This plan has a fixed price of" => "This plan has a fixed price of",
            "Confirm" => "Confirm",
            "Cancel" => "Cancel",
            "ROI" => "ROI", 
            "Duration" => "Duration", 
            "Profit Return" => "Profit Return", 
            "Select" => "Select", 
            "Confirm Loan Application" => "Confirm Loan Application", 
            "Please enter an amount between" => "Please enter an amount between", 
            "Enter OTP" => "Enter OTP", 
            "Submit Loan Application" => "Submit Loan Application", 
            "My Loans" => "My Loans",
            "Total loaned" => "Total loaned", 
            "Pending loans" => "Pending loans", 
            "Repaid loans" => "Repaid loans", 
            "Unpaid loans" => "Unpaid loans",
            "Interest" => "Interest",
            "Total Repayable" => "Total Repayable",
            "Date Borrowed" => "Date Borrowed", 
            "Repayment Date" => "Repayment Date", 
            "Pay Now" => "Pay Now",
            "New Loan" => "New Loan",
            "No loans to display" => "No loans to display", 
            "You don't have any loans at this time." => "You don't have any loans at this time.", 
            "Select New Loan Plan" => "Select New Loan Plan",
            "Min Deposit To Qualify" => "Min Deposit To Qualify",
            "You have pending or unpaid loan(s), please pay up to qualify for a new loan" => "You have pending or unpaid loan(s), please pay up to qualify for a new loan",
            "Pay With" => "Pay With",
            "You have selected to deposit" => "You have selected to deposit",
            "via" => "via",
            "A depsoit charge of" => "A depsoit charge of", 
            "has been applied to your deposit. Follow the payment instruction to complete your payment" => "has been applied to your deposit. Follow the payment instruction to complete your payment",
            "Payment Instruction" => "Payment Instruction", 
            "Name on card" => "Name on card",
            "Card number" => "Card number",
            "CVV" => "CVV",
            "Cancel payment?" => "Cancel payment?", 
            "Are you sure you want to cancel your payment?" => "Are you sure you want to cancel your payment?",
            "Yes, cancel" => "Yes, cancel",
            "Please correct the errors and try again." => "Please correct the errors and try again.",
            "No" => "No", 
            "Complete your payment" => "Complete your payment",
            "Network Type" => "Network Type",
            "Wallet Address" => "Wallet Address",
            "Bank Name" => "Bank Name",
            "Account Name" => "Account Name",
            "Account No" => "Account No",
            "Sort Code" => "Sort Code",
            "Bank Code" => "Bank Code",
            "Save Deposit" => "Save Deposit",
            "Upload payment screenshot" => "Upload payment screenshot",
            "Enter comment" => "Enter comment",
            "Save" => "Save",
            "Create Ticket" => "Create Ticket",
            "new" => "new",
            "open" => "open",
            "closed" => "closed",
            "pending" => "pending",
            'approved' => "approved",
            "resolved" => "resolved",
            "rejected" => "rejected",
            "Reply" => "Reply",
            "Mark as resolved" => "Mark as resolved",
            "You don't have any support tickets." => "You don't have any support tickets.",
            "Subject" => "Subject",
            "Add a message" => "Add a message",
            "Add attachment(s)" => "Add attachment(s)",
            "Submit Ticket" => "Submit Ticket",
            "Admin" => "Admin",
            "Add a reply" => "Add a reply",
            "Add attachment(s)" => "Add attachment(s)",
            "Send Reply" => "Send Reply",
            "Welcome to Demo Dashboard" => "Welcome to Demo Dashboard",
            "Start Trading" => "Start Trading",
            "TYPE" => "TYPE",
            "buy" => "buy",
            "sell" => "sell",
            "market" => "market",
            "limit" => "limit",
            "stop-limit" => "stop-limit",
            "stop limit" => "stop limit",
            "End Trade" => "End Trade",
            "active" => "active",
            "win" => "wim",
            "lose" => "lose",
            'inactive' => 'inactive',
            "You don't have any trades" => "You don't have any trades",
            "Demo Wallets" => "Demo Wallets",
            "You don't have any wallets" => "You don't have any wallets",
            "demo" => "demo",
            "Dashboard" => "Dashboard",
            "Search Pair" => "Search Pair",
            "Coin" => "Coin",
            "Price" => "Price",
            "Change" => "Change",
            "Last Price" => "Last Price",
            "High" => "High",
            "Low" => "Low",
            "Volume 24Hr" => "Volume 24Hr",
            "TP/SL" => "TP/SL",
            "Take Profit" => "Take Profit",
            "Stop Loss" => "Stop Loss",
            "Total" => "Total",
            "Available" => "Available",
            "market trading" => "market trading",
            "history" => "history",
            "Time" => "Time",
            "Volume" => "Volume",
            "Balance" => "Balance",
            "Closed Orders" => "Closed Orders",
            "Active Orders" => "Active Orders",
            "Leverage" => "Leverage",
            "Buy/sell" => "Buy/sell",
            "Currency" => "Currency",
            "Icon" => "Icon",
            "Staking Period" => "Staking Period",
            "APR" => "APR",
            "Stake Rate" => "Stake Rate",
            "Coin Distrbution" => "Coin Distrbution",
            "Your Stake" => "Your Stake",
            "Stake Now" => "Stake Now",
            "Maxed" => "Maxed",
            "There are no user coins found." => "There are no user coins found.",
            "Delete Wallet!" => "Delete Wallet!",
            "Do you want to delete this coins? It can't be reversed" => "Do you want to delete this coins? It can't be reversed",
            "New Staking" => "New Staking",
            "BOT" => "BOT",
            "Success" => "Success",
            "Error" => "Error",
            "RUNNING" => "RUNNING",
            "Stop Bot" => "Stop Bot",
            "Start Bot" => "Start Bot", 
            "Operation" => "Operation",
            "Activate" => "Activate",
            "Deposit" => "Deposit",
            "Account Balance" => "Account Balance",
            "wallet" => "wallet",
            "Disclaimer" => "Disclaimer",
            "You are about to fund your" => "You are about to fund your",
            "wallet. The amount would be deducted from your Account Balance." => "wallet. The amount would be deducted from your Account Balance.",
            "Fiat Balance" => "Fiat Balance",
            "Enter amount to fund" => "Enter amount to fund",
            "GO" => "GO",
            "My Trading Wallets" => "My Trading Wallets",
            "New Wallet" => "New Wallet",
            "Symbol" => "Symbol",
            "Transactions" => "Transactions",
            "You haven't added any wallet." => "You haven't added any wallet.",
            "Wallet Created successfuly" => "Wallet Created successfuly",
            "Add New Wallet" => "Add New Wallet",
            "Create" => "Create"
            

        ];

        $trans = array_change_key_case($trans); 

        ksort($trans);
        $trans = json_encode($trans);
        file_put_contents(base_path('lang/en.json'), $trans);
        file_put_contents(base_path('lang/de.json'), $trans);
    }
}
