<?php

namespace Modules\ManualDeposit\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Nwidart\Modules\Facades\Module;

class ManualDepositInstallerController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */

    public function install()
    {
        $addon = 'ManualDeposit';
        //Check if the user has activated this addon before
        $check_addon = checkAddon($addon);
        $module = Module::find($addon);
        $path = $module->getpath();
        //$database = $path . '/Database/cryptotrading.sql';

        $status = $check_addon['status'] ?? 'fail';
        if ( $status == 'success') {

            //check for database import            
            
            //make active
            $module->enable();  
        } 

        return redirect(route('admin.addons.index'))->with($check_addon['status'] ?? 'fail', $check_addon['message'] ?? 'Failed to install ' . $addon);

        

    }
}