<?php

namespace Modules\ManualDeposit\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ManualDepositMethod;


class DepositMethodController extends Controller
{
    //get index of deposit method
    public function index()
    {
        $page_title = 'Manual Deposit Methods';
        $methods = ManualDepositMethod::where('class', 'manual')->orderby('name', 'ASC')->get();

        return view('manualdeposit::admin.deposit-methods.index', compact(
            'page_title',
            'methods'
        ));
    }

    //add new deposit method
    public function addNew(Request $request)
    {
        $page_title = 'Add New Deposit Method';
        $currencies = getCurrency();

        return view('manualdeposit::admin.deposit-methods.new', compact(
            'page_title',
            'currencies'
        ));
    }

    ///process add new method
    public function addNewValidate(Request $request)
    {
        if (!session()->has('type')) {
            $request->validate([
                'type' => 'required'
            ]);

            $request->session()->put('type', $request->type);
            return back()->with('success', 'you have selected ' . $request->type);
        } elseif (session()->has('type')) {
            if (session()->get('type') == 'crypto') {
                //validate crypto required inputs
                $request->validate([
                    'name' => 'required',
                    'min_amount' => 'required',
                    'max_amount' => 'required',
                    'charge' => 'required',
                    'charge_type' => 'required',
                    'currency' => 'required',
                    'wallet_address' => 'required',
                    'network_type' => 'required',
                    'payment_instruction' => 'required',
                    'logo' => 'required'
                ]);
            } elseif (session()->get('type') == 'bank') {
                //validate bank required inputs
                $request->validate([
                    'name' => 'required',
                    'min_amount' => 'required',
                    'max_amount' => 'required',
                    'charge' => 'required',
                    'charge_type' => 'required',
                    'currency' => 'required',
                    'bank_name' => 'required',
                    'account_name' => 'required',
                    'account_no' => 'required',
                    'sort_code' => 'required',
                    'bank_code' => 'required',
                    'payment_instruction' => 'required',
                    'logo' => 'required'
                ]);
            } elseif (session()->get('type') == 'others') {
                //validate 'others' required inputs
                $request->validate([
                    'name' => 'required',
                    'min_amount' => 'required',
                    'max_amount' => 'required',
                    'charge' => 'required',
                    'charge_type' => 'required',
                    'currency' => 'required',
                    'payment_instruction' => 'required',
                    'logo' => 'required'
                ]);
            }

            //upload logo
            $logo  = uploadImage($request->file('logo'), 'deposit-methods');

            //save method
            $method = new ManualDepositMethod();
            $method->name = $request->name;
            $method->type = session()->get('type');
            $method->status = 'active';
            $method->min_amount = $request->min_amount;
            $method->max_amount = $request->max_amount;
            $method->charge = $request->charge;
            $method->charge_type = $request->charge_type;
            $method->currency = $request->currency;
            $method->wallet_address = $request->wallet_address;
            $method->network_type = $request->network_type;
            $method->payment_instruction = $request->payment_instruction;
            $method->bank_name = $request->bank_name;
            $method->account_name = $request->account_name;
            $method->account_no = $request->account_no;
            $method->bank_code = $request->bank_code;
            $method->sort_code = $request->sort_code;
            $method->logo = $logo;
            $save_method = $method->save();

            //delete stored 'type' from session
            if ($save_method) {
                session()->pull('type');
                return back()->with('success', $request->name . ' has been saved as a deposit method');
            } else {
                return back()->with('fail', $request->name . ' could not be saved as a deposit method');
            }
        } else {
            return back()->with('fail',  'Invalid Request');
        }
    }

    //edit existing deposit methods
    public function editMethod(Request $request)
    {
        $method = ManualDepositMethod::where('id', $request->route('id'))->first();
        $page_title = 'Edit ' . $method->name;
        $currencies = getCurrency();



        return view('manualdeposit::admin.deposit-methods.edit', compact(
            'method',
            'page_title',
            'currencies'
        ));
    }

    //validate edit 
    public function editMethodValidate(Request $request)
    {

        if ($request->type == 'crypto') {
            $request->validate([
                'id' => 'required',
                'name' => 'required',
                'status' => 'required',
                'min_amount' => 'required',
                'max_amount' => 'required',
                'charge' => 'required',
                'charge_type' => 'required',
                'currency' => 'required',
                'wallet_address' => 'required',
                'network_type' => 'required',
                'payment_instruction' => 'required'


            ]);

            if ($request->file('logo')) {
                //upload logo
                $new_logo = uploadImage($request->file('logo'), 'deposit-methods');
            }



            $update = ManualDepositMethod::find($request->id);
            $update->name = $request->name;
            $update->status = $request->status;
            $update->min_amount = $request->min_amount;
            $update->max_amount = $request->max_amount;
            $update->charge = $request->charge;
            $update->charge_type = $request->charge_type;
            $update->currency = $request->currency;
            $update->wallet_address = $request->wallet_address;
            $update->network_type = $request->network_type;
            $update->payment_instruction = $request->payment_instruction;
            if ($request->file('logo')) {
                $update->logo = $new_logo;
            }
            $save_update = $update->save();
            if ($save_update) {
                return back()->with('success', $request->name . ' deposit method has been updated');
            }
            //$update->



        } elseif ($request->type == 'bank') {
            $request->validate([
                'id' => 'required',
                'name' => 'required',
                'status' => 'required',
                'min_amount' => 'required',
                'max_amount' => 'required',
                'charge' => 'required',
                'charge_type' => 'required',
                'currency' => 'required',
                'bank_name' => 'required',
                'account_name' => 'required',
                'account_no' => 'required',
                'bank_code' => 'required',
                'sort_code' => 'required',
                'payment_instruction' => 'required'


            ]);

            if ($request->file('logo')) {
                //upload logo
                $new_logo = uploadImage($request->file('logo'), 'deposit-methods');
            }

            $update = ManualDepositMethod::find($request->id);
            $update->name = $request->name;
            $update->status = $request->status;
            $update->min_amount = $request->min_amount;
            $update->max_amount = $request->max_amount;
            $update->charge = $request->charge;
            $update->charge_type = $request->charge_type;
            $update->currency = $request->currency;
            $update->bank_name = $request->bank_name;
            $update->account_name = $request->account_name;
            $update->account_no = $request->account_no;
            $update->sort_code = $request->sort_code;
            $update->bank_code = $request->bank_code;
            $update->payment_instruction = $request->payment_instruction;
            if ($request->file('logo')) {
                $update->logo = $new_logo;
            }
            $save_update = $update->save();
            if ($save_update) {
                return back()->with('success', $request->name . ' deposit method has been updated');
            }
        } elseif ($request->type == 'others') {
            $request->validate([
                'id' => 'required',
                'name' => 'required',
                'status' => 'required',
                'min_amount' => 'required',
                'max_amount' => 'required',
                'charge' => 'required',
                'charge_type' => 'required',
                'currency' => 'required',
                'payment_instruction' => 'required'


            ]);

            if ($request->file('logo')) {
                //upload logo
                $new_logo = uploadImage($request->file('logo'), 'deposit-methods');
            }

            $update = ManualDepositMethod::find($request->id);
            $update->name = $request->name;
            $update->status = $request->status;
            $update->min_amount = $request->min_amount;
            $update->max_amount = $request->max_amount;
            $update->charge = $request->charge;
            $update->charge_type = $request->charge_type;
            $update->currency = $request->currency;
            $update->payment_instruction = $request->payment_instruction;
            if ($request->file('logo')) {
                $update->logo = $new_logo;
            }
            $save_update = $update->save();
            if ($save_update) {
                return back()->with('success', $request->name . ' deposit method has been updated');
            }
        }
    }

    //deactivate deposit method
    public function disableMethod(Request $request)
    {
        $deactivate =  ManualDepositMethod::find($request->route('id'));
        $deactivate->status = 'inactive';
        $save = $deactivate->save();

        //specify redirect url
        if ($deactivate->class == 'gateway') {
            $url = route('admin.settings.gateways.index');
        }else {
            $url = route('admin.deposit-method.index');
        }
        if ($save) {
            return redirect($url)->with('success', 'Deposit Method deactivated successfully');
        } else {
            return redirect($url)->with('fail', 'Deposit Method could not be deactivated');
        }
    }

    //reactivate deposit method
    public function enableMethod(Request $request)
    {
        $method =  ManualDepositMethod::find($request->route('id'));
        $method->status = 'active';
        $save = $method->save();
        //specify redirect url
        if ($method->class == 'gateway') {
            $url = route('admin.settings.gateways.index');
        }else {
            $url = route('admin.deposit-method.index');
        }
        if ($save) {
            return redirect($url)->with('success', 'Deposit Method enabled successfully');
        } else {
            return redirect($url)->with('fail', 'Deposit Method could not be enabled');
        }
    }

    //delete existing deposit method
    public function deleteMethod(Request $request)
    {
        $method =  ManualDepositMethod::find($request->route('id'));
        $delete = $method->delete();

        if ($delete) {
            return redirect(route('admin.deposit-method.index'))->with('success', 'Deposit Method deletected successfully');
        } else {
            return redirect(route('admin.deposit-method.index'))->with('fail', 'Deposit Method could not be deleted');
        }
    }

    public function cancel(){
        //delete type from session
        session()->pull('type');
        return redirect(route('admin.deposit-method.new'))->with('success', 'Deposit Method cancelled successfully');
    }
}
