<?php

use App\Models\ManualDepositMethod;
use App\Models\User;
use Modules\CryptoLoan\Entities\Loan;
use Modules\CryptoLoan\Entities\LoanPlan;
use Modules\CryptoTrading\Entities\TradingWallet;
use Modules\CryptoTrading\Entities\TradingWalletTransaction;
use Modules\KYC\Entities\IdVerification;
use Modules\P2pTransfer\Entities\Transfer;
use Modules\SupportTicket\Entities\SupportTicket;
use Modules\SupportTicket\Entities\SupportTicketAttachment;
use Modules\SupportTicket\Entities\SupportTicketReply;
use Nwidart\Modules\Facades\Module;


//check addon
if (!function_exists('checkAddon')) {
    function checkAddon($addon)
    {

        $base_curl = "https://credcrypto.net/api";
        $request_origin = $_SERVER['HTTP_HOST'];
        $url = $base_curl . '/v1/addons/' . $addon;
        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        $headers = array(
            "request-origin: " . $request_origin,
            "theme:" .websiteInfo('theme')

        );
        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);

        //for debug only!
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);

        $resp = curl_exec($curl);

        curl_close($curl);
        $resp = json_decode($resp, true);
        return $resp;
    }
}

//Authorize starts here

if (!function_exists('updateAuthorizeNet')) {
    function updateAuthorizeNet($request)
    {
        $check = checkAddon('authorizenet');
        $status = $check['status'] ?? 'fail';
        if ($status  == 'fail') {
            $module = Module::find('authorizenet');
            $module->disable();

            return false;
        }

        //validate input
        $request->validate([
            //general
            'id' => 'required',
            'min_amount' => 'required|numeric',
            'max_amount' => 'required|numeric',
            'charge_type' => 'required',
            'charge' => 'required|numeric',
            'status' => 'required',
            'payment_instruction' => 'required',

            //config
            'authorize_api_id' => 'required',
            'authorize_transaction_key' => 'required',
        ]);

        //save config
        setEnv('AUTHORIZE_API_ID', $request->authorize_api_id);
        setEnv('AUTHORIZE_TRANSACTION_KEY', $request->authorize_transaction_key);

        //save general
        $general = ManualDepositMethod::find($request->id);
        $general->min_amount = $request->min_amount;
        $general->max_amount = $request->max_amount;
        $general->charge_type = $request->charge_type;
        $general->charge = $request->charge;
        $general->status = $request->status;
        $general->payment_instruction = $request->payment_instruction;
        $save_general = $general->save();

        if ($save_general) {
            return true;
        } else {
            return false;
        }
    }
}


// Cashmaal starts here
if (!function_exists('updateCashmaal')) {
    function updateCashmaal($request)
    {
        $check = checkAddon('cashmaal');
        $status = $check['status'] ?? 'fail';
        if ($status  == 'fail') {
            $module = Module::find('cashmaal');
            $module->disable();
            return false;
        } else {
            //validate input
            $request->validate([
                //general
                'id' => 'required',
                'min_amount' => 'required|numeric',
                'max_amount' => 'required|numeric',
                'charge_type' => 'required',
                'charge' => 'required|numeric',
                'status' => 'required',
                'payment_instruction' => 'required',

                //config
                'cm_web_id' => 'required',
            ]);

            //save config
            setEnv('CM_WEB_ID', $request->cm_web_id);

            //save general
            $general = ManualDepositMethod::find($request->id);
            $general->min_amount = $request->min_amount;
            $general->max_amount = $request->max_amount;
            $general->charge_type = $request->charge_type;
            $general->charge = $request->charge;
            $general->status = $request->status;
            $general->payment_instruction = $request->payment_instruction;
            $save_general = $general->save();

            if ($save_general) {
                return true;
            } else {
                return false;
            }
        }
    }
}


// Coinbase starts here
if (!function_exists('updateCoinbase')) {
    function updateCoinbase($request)
    {
        $check = checkAddon('coinbase');
        $status = $check['status'] ?? 'fail';
        if ($status  == 'fail') {
            $module = Module::find('coinbase');
            $module->disable();
            return false;
        } else {
            //validate input
            $request->validate([
                //general
                'id' => 'required',
                'min_amount' => 'required|numeric',
                'max_amount' => 'required|numeric',
                'charge_type' => 'required',
                'charge' => 'required|numeric',
                'status' => 'required',
                'payment_instruction' => 'required',

                //config
                'coin_base_api_key' => 'required',
                'coin_base_web_hook_sec' => 'required',
            ]);

            //save config
            setEnv('COIN_BASE_API_KEY', $request->coin_base_api_key);
            setEnv('COIN_BASE_WEB_HOOK_SEC', $request->coin_base_web_hook_sec);

            //save general
            $general = ManualDepositMethod::find($request->id);
            $general->min_amount = $request->min_amount;
            $general->max_amount = $request->max_amount;
            $general->charge_type = $request->charge_type;
            $general->charge = $request->charge;
            $general->status = $request->status;
            $general->payment_instruction = $request->payment_instruction;
            $save_general = $general->save();

            if ($save_general) {
                return true;
            } else {
                return false;
            }
        }
    }
}

// Coingate starts here
if (!function_exists('updateCoingate')) {
    function updateCoingate($request)
    {
        $check = checkAddon('coingate');
        $status = $check['status'] ?? 'fail';
        if ($status  == 'fail') {
            $module = Module::find('coingate');
            $module->disable();
            return false;
        } else {
            //validate input
            $request->validate([
                //general
                'id' => 'required',
                'min_amount' => 'required|numeric',
                'max_amount' => 'required|numeric',
                'charge_type' => 'required',
                'charge' => 'required|numeric',
                'status' => 'required',
                'payment_instruction' => 'required',

                //config
                'cg_auth_token' => 'required',
                'cg_mode' => 'required',
            ]);

            //save config
            setEnv('CG_AUTH_TOKEN', $request->cg_auth_token);
            setEnv('CG_MODE', $request->cg_mode);

            //save general
            $general = ManualDepositMethod::find($request->id);
            $general->min_amount = $request->min_amount;
            $general->max_amount = $request->max_amount;
            $general->charge_type = $request->charge_type;
            $general->charge = $request->charge;
            $general->status = $request->status;
            $general->payment_instruction = $request->payment_instruction;
            $save_general = $general->save();

            if ($save_general) {
                return true;
            } else {
                return false;
            }
        }
    }
}


// Loan starts here
if(!function_exists('getLoans')) {
    function getLoans(Int $user_id = Null)
    {
        if ($user_id) {
            $loans = Loan::where('user_id', $user_id)->get();
        } else {
            $loans = Loan::get();
        }

        return $loans;
    }
}


//process loan
if (!function_exists('processLoan')) {
    function processLoan($loan_id, $loan_action, $rpd)
    {
        $base_curl = env('BASE_CURL');
        $request_origin = $_SERVER['HTTP_HOST'];
        $url = $base_curl . '/v1/loan';
        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        $headers = array(
            
            "request-origin: " . $request_origin,
            "loan-id: " . $loan_id,
            "action: " . $loan_action,
            "rpd: " . $rpd,

        );
        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);

        //for debug only!
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);

        $resp = curl_exec($curl);
        curl_close($curl);
        $resp = json_decode($resp, true);


        if ($resp['action'] ?? null == 'rejected') {
            //change loan status
            $change_status = Loan::find($resp['loan_id']);
            $change_status->status = $resp['action'];
            $change_status->save();
            $message = 'rejected';
            sendLoanProcessedEmail($resp['loan_id']);
            return $message;
        } elseif ($resp['action'] ?? null == 'approved') {
            //credit the borrower
            $loan = Loan::where('id', $resp['loan_id'])->first();
            $borrower = User::where('id', $loan->user_id)->first();
            $new_bal = $borrower->account_bal + $loan->amount;
            $credit = User::find($borrower->id);
            $credit->account_bal = $new_bal;
            $credit->save();

            //change loan status
            $change_status = Loan::find($resp['loan_id']);
            $change_status->status = $resp['action'];
            $change_status->repayment_date = $resp['repayment_date'];
            $change_status->save();

            //record new transaction
            recordNewTransaction($loan->user_id, 'credit', $loan->amount, 'Loan', $new_bal, 'Loan Credited');

            //send loan approved email
            sendLoanProcessedEmail($resp['loan_id']);

            $message = 'approved';
            return $message;
        }
    }
}

if (!function_exists('getLoanPlans')) {
    function getLoanPlans()
    {
        return LoanPlan::get();
    }
}

// Crypto trading starts here
//Retrieve all users trading wallets
if (!function_exists('tradingWallet')) {
    function tradingWallet() 
    {
        return TradingWallet::where('user_id', user('id'))->get();
    }
}

//record transction
if (!function_exists('recordCoinTransaction')) {
    function recordCoinTransaction($user_id, $wallet_id, $symbol,  $type, $order_type,  $amount)
    {
        //generate transaction id 
        $txn_id = bin2hex(random_bytes(16));
        $transaction = new TradingWalletTransaction();
        $transaction->user_id = $user_id;
        $transaction->wallet_id = $wallet_id;
        $transaction->symbol = $symbol;
        $transaction->type = $type;
        $transaction->order_type = $order_type;
        $transaction->amount = $amount;
        $transaction->save();
        return true;
    }
}

//get pair price
if (!function_exists('pairPrice')) {
    function pairPrice($pair) 
    {
        if (strtolower($pair) == 'usdt_usdt') {
            return 1;
        }
        //get trading pair price
        $url = "https://api.poloniex.com/markets/" . $pair . "/price";
        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

        //for debug only!
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);

        $resp = curl_exec($curl);
        curl_close($curl);

        $price = json_decode($resp);
        $price = $price->price;

        return $price;
    }
}


// Flutter wave starts here
if (!function_exists('updateFlutterwave')) {
    function updateFlutterwave($request)
    {
        $check = checkAddon('flutterwave');
        $status = $check['status'] ?? 'fail';
        if ($status  == 'fail') {
            $module = Module::find('flutterwave');
            $module->disable();
            return false;
        } else {
            //validate input
            $request->validate([
                //general
                'id' => 'required',
                'min_amount' => 'required|numeric',
                'max_amount' => 'required|numeric',
                'charge_type' => 'required',
                'charge' => 'required|numeric',
                'status' => 'required',
                'payment_instruction' => 'required',

                //config
                'flw_pub_key' => 'required',
                'flw_sec_key' => 'required',
            ]);

            //save config
            setEnv('FLW_PUB_KEY', $request->flw_pub_key);
            setEnv('FLW_SEC_KEY', $request->flw_sec_key);

            //save general
            $general = ManualDepositMethod::find($request->id);
            $general->min_amount = $request->min_amount;
            $general->max_amount = $request->max_amount;
            $general->charge_type = $request->charge_type;
            $general->charge = $request->charge;
            $general->status = $request->status;
            $general->payment_instruction = $request->payment_instruction;
            $save_general = $general->save();

            if ($save_general) {
                return true;
            } else {
                return false;
            }
        }
    }
}


// KYC starts here
//process User ID Verification
if (!function_exists('processUserId')) {
    function processUserId($document_id, $action, $comment)
    {
        $comment =  str_replace(' ', '+', $comment);
        $base_curl = env('BASE_CURL');
        $request_origin = $_SERVER['HTTP_HOST'];
        $url = $base_curl . '/v1/id';
        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        $headers = array(
            
            "request-origin: " . $request_origin,
            "document-id: " . $document_id,
            "comment: " . $comment,
            "action: " . $action,

        );
        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);


        //for debug only!
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);

        $resp = curl_exec($curl);
        curl_close($curl);
        $resp = json_decode($resp, true);

        if (!$resp) {
            return false;
        }

        $process_id = IdVerification::find($resp['document_id']);
        $process_id->comment = $resp['comment'];
        $process_id->save();
        //change user status
        if ($resp['action'] == 'reject') {
            $user_verify_status = 'rejected';
        } else {
            $user_verify_status = 'verified';
        }
        $user_id =  IdVerification::where('id', $resp['document_id'])->first();
        $update_user = User::find($user_id->user_id);
        $update_user->id_verified = $user_verify_status;
        $update_user->save();

        //send notification email
        sendIdProcessedEmail($user_id->user_id, $user_verify_status, $resp['comment']);
        return true;
    }
}

// Monify starts here
if (!function_exists('updateMonnify')) {
    function updateMonnify($request)
    {
        $check = checkAddon('monnify');
        $status = $check['status'] ?? 'fail';
        if ($status  == 'fail') {
            $module = Module::find('monnify');
            $module->disable();
            return false;
        } else {
            //validate input
            $request->validate([
                //general
                'id' => 'required',
                'min_amount' => 'required|numeric',
                'max_amount' => 'required|numeric',
                'charge_type' => 'required',
                'charge' => 'required|numeric',
                'status' => 'required',
                'payment_instruction' => 'required',

                //config
                'monnify_api_key' => 'required',
                'monnify_secret_key' => 'required',
                'monnify_base_url' => 'required',
                'monnify_contract_code' => 'required',
            ]);


            //save config
            setEnv('MONNIFY_API_KEY', $request->monnify_api_key);
            setEnv('MONNIFY_SECRET_KEY', $request->monnify_secret_key);
            setEnv('MONNIFY_BASE_URL', $request->monnify_base_url);
            setEnv('MONNIFY_CONTRACT_CODE', $request->monnify_contract_code);

            //save general
            $general = ManualDepositMethod::find($request->id);
            $general->min_amount = $request->min_amount;
            $general->max_amount = $request->max_amount;
            $general->charge_type = $request->charge_type;
            $general->charge = $request->charge;
            $general->status = $request->status;
            $general->payment_instruction = $request->payment_instruction;
            $save_general = $general->save();

            if ($save_general) {
                return true;
            } else {
                return false;
            }
        }
    }
}

// p2p transfer starts here
//get transfers
if (!function_exists('getTransfers')) {
    function getTransfers(Int $user_id = Null)
    {
        if ($user_id) {
            $transfers = Transfer::where('sender_id', $user_id)
            ->orWhere('receiver_id', $user_id)
            ->get();
        }  else {
            $transfers = Transfer::get();
        }

        return $transfers;
        
    }
}

//process wallet transfer 
if (!function_exists('processTransfer')) {
    function processTransfer($receiver_account_id, $total_amount, $amount, $transfer_fee, $narration, $txn_id)
    {
        $receiver = User::where('account_id', $receiver_account_id)->first();
        //initialize transfer

        if (websiteInfo('transfer_auto_approve') == 'enabled' && $check_health['status'] = 'ok') {
            //debit sender 
            $new_bal = (user('account_bal') - $total_amount);
            $sender = User::find(user('id'));
            $sender->account_bal = $new_bal;
            $sender->save();

            //save transfer 
            $transfer = new Transfer();
            $transfer->sender_id = User('id');
            $transfer->receiver_id = $receiver->id;
            $transfer->amount = $amount;
            $transfer->fee = $transfer_fee;
            $transfer->total = $total_amount;
            $transfer->status = 'approved';
            $transfer->txn_id = $txn_id;
            $transfer->narration = $narration;
            $transfer->save();

            //log transaction - sender
            recordNewTransaction(user('id'), 'debit', $total_amount,  'Transfer to ' . $receiver->account_id, $new_bal, $narration);


            //credit receiver            
            $new_bal = ($receiver->account_bal + $amount);
            $credit_receiver = User::find($receiver->id);
            $credit_receiver->account_bal = $new_bal;
            $credit_receiver->save();

            //log transaction - receiver
            recordNewTransaction($receiver->id, 'credit', $amount,  'Transfer from ' . user('account_id'), $new_bal, $narration);
            return;
        } elseif (websiteInfo('transfer_auto_approve') == 'disabled' && $check_health['status'] = 'ok') {
            //debit sender 
            $new_bal = (user('account_bal') - $total_amount);
            $sender = User::find(user('id'));
            $sender->account_bal = $new_bal;
            $sender->save();

            //save transfer 
            $transfer = new Transfer();
            $transfer->sender_id = User('id');
            $transfer->receiver_id = $receiver->id;
            $transfer->amount = $amount;
            $transfer->fee = $transfer_fee;
            $transfer->total = $total_amount;
            $transfer->status = 'pending';
            $transfer->txn_id = $txn_id;
            $transfer->narration = $narration;
            $transfer->save();

            //log transaction - sender
            recordNewTransaction(user('id'), 'debit', $total_amount,  'Transfer to ' . $receiver->account_id, $new_bal, $narration);
            return true;
        } else {
            //debit sender 
            $new_bal = (user('acount_bal') - $total_amount);
            $sender = User::find(user('id'));
            $sender->account_bal = $new_bal;
            $sender->save();

            //save transfer 
            $transfer = new Transfer();
            $transfer->sender_id = User('id');
            $transfer->receiver_id = $receiver->id;
            $transfer->amount = $amount;
            $transfer->fee = $transfer_fee;
            $transfer->total = $total_amount;
            $transfer->status = 'approved';
            $transfer->txn_id = $txn_id;
            $transfer->narration = $narration;
            $transfer->save();

            //log transaction - sender
            recordNewTransaction(user('id'), 'debit', $total_amount,  'Transfer to ' . $receiver->account_id, $new_bal, $narration);


            //credit receiver            
            $new_bal = ($receiver->account_bal - $amount);
            $credit_receiver = User::find($receiver->id);
            $credit_receiver->account_bal = $new_bal;
            $credit_receiver->save();

            //log transaction - receiver
            recordNewTransaction($receiver->id, 'credit', $amount,  'Transfer from ' . user('account_id'), $new_bal, $narration);
            return;
        }
    }
}

// Paypal starts here
if (!function_exists('updatePayPal')) {
    function updatePayPal($request)
    {
        $check = checkAddon('paypal');
        $status = $check['status'] ?? 'fail';
        if ($status  == 'fail') {
            $module = Module::find('paypal');
            $module->disable();
            return false;
        } else {
            $request->validate([
                //general
                'id' => 'required',
                'min_amount' => 'required|numeric',
                'max_amount' => 'required|numeric',
                'charge_type' => 'required',
                'charge' => 'required|numeric',
                'status' => 'required',
                'payment_instruction' => 'required',

                //config
                'paypal_sand_box_client_id' => 'required',
                'paypal_sand_box_client_secret' => 'required',
                'paypal_live_client_id' => 'required',
                'paypal_live_client_secret' => 'required',
                'paypal_mode' => 'required',
                'paypal_sand_box_app_id' => 'required',
                'paypal_live_app_id' => 'required',


            ]);

            //save config
            websiteInfoUpdate('paypal_sand_box_client_id', $request->paypal_sand_box_client_id);
            websiteInfoUpdate('paypal_sand_box_client_secret', $request->paypal_sand_box_client_secret);
            websiteInfoUpdate('paypal_live_client_id', $request->paypal_live_client_id);
            websiteInfoUpdate('paypal_live_client_secret', $request->paypal_live_client_secret);
            websiteInfoUpdate('paypal_mode', $request->paypal_mode);
            websiteInfoUpdate('paypal_sand_box_app_id', $request->paypal_sand_box_app_id);
            websiteInfoUpdate('paypal_live_app_id', $request->paypal_live_app_id);



            //save general
            $general = ManualDepositMethod::find($request->id);
            $general->min_amount = $request->min_amount;
            $general->max_amount = $request->max_amount;
            $general->charge_type = $request->charge_type;
            $general->charge = $request->charge;
            $general->status = $request->status;
            $general->payment_instruction = $request->payment_instruction;
            $save_general = $general->save();

            if ($save_general) {
                return true;
            } else {
                return false;
            }
        }
    }
}

// Razor pay starts here
if (!function_exists('updateRazorPay')) {
    function updateRazorPay($request)
    {
        $check = checkAddon('razorpay');
        $status = $check['status'] ?? 'fail';
        if ($status  == 'fail') {
            $module = Module::find('razorpay');
            $module->disable();
            return false;
        } else {
            $request->validate([
                //general
                'id' => 'required',
                'min_amount' => 'required|numeric',
                'max_amount' => 'required|numeric',
                'charge_type' => 'required',
                'charge' => 'required|numeric',
                'status' => 'required',
                'payment_instruction' => 'required',

                //config
                'rzp_key_id' => 'required',
                'rzp_key_secret' => 'required',


            ]);


            //save config
            setEnv('RZP_KEY_ID', $request->rzp_key_id);
            setEnv('RZP_KEY_SECRET', $request->rzp_key_secret);



            //save general
            $general = ManualDepositMethod::find($request->id);
            $general->min_amount = $request->min_amount;
            $general->max_amount = $request->max_amount;
            $general->charge_type = $request->charge_type;
            $general->charge = $request->charge;
            $general->status = $request->status;
            $general->payment_instruction = $request->payment_instruction;
            $save_general = $general->save();

            if ($save_general) {
                return true;
            } else {
                return false;
            } 
        }
    }
}

// stripe starts here
if (!function_exists('updateStripe')) {
    function updateStripe($request)
    {
        $check = checkAddon('stripe');
        $status = $check['status'] ?? 'fail';
        if ($status  == 'fail') {
            $module = Module::find('stripe');
            $module->disable();
            return false;
        } else {
            //validate input
            $request->validate([
                //general
                'id' => 'required',
                'min_amount' => 'required|numeric',
                'max_amount' => 'required|numeric',
                'charge_type' => 'required',
                'charge' => 'required|numeric',
                'status' => 'required',
                'payment_instruction' => 'required',

                //config
                'stripe_key' => 'required',
                'stripe_secret' => 'required',


            ]);


            //save config
            setEnv('STRIPE_KEY', $request->stripe_key);
            setEnv('STRIPE_SECRET', $request->stripe_secret);



            //save general
            $general = ManualDepositMethod::find($request->id);
            $general->min_amount = $request->min_amount;
            $general->max_amount = $request->max_amount;
            $general->charge_type = $request->charge_type;
            $general->charge = $request->charge;
            $general->status = $request->status;
            $general->payment_instruction = $request->payment_instruction;
            $save_general = $general->save();

            if ($save_general) {
                return true;
            } else {
                return false;
            }
        }
    }
}

// Support ticket starts here
//get the ticket attachments and replies
if (!function_exists('TicketInfo')) {
    function TicketInfo($ticket_id, $type)
    {
        //types are attachments and replys
        if (!$ticket_id || !$type) {
            return false;
        }

        if ($type == 'attachment') {
            $attachments = SupportTicketAttachment::where('ticket_id', $ticket_id)->get();
            return $attachments;
        } elseif ($type == 'reply') {
            $replies = SupportTicketReply::where('ticket_id', $ticket_id)->get();
            return $replies;
        } else {
            return false;
        }
    }
}


//get tickets 
if(!function_exists('getTickets')) {
    function getTickets(Int $user_id = Null)
    {
        $tickets = '';
        if ($user_id){
            $tickets = SupportTicket::where('user_id', $user_id)->get();
        } else {
            $tickets = SupportTicket::get();
        }

        return $tickets;
    }
}



